//texture tex0 < string name = "Beach.tga"; >;
//texture tex1 < string name = "Beach.tga"; >;
//texture tex2 < string name = "Beach.tga"; >;
//texture tex3 < string name = "Beach.tga"; >;

float4x4 WorldMatrix; 
float4x4 ViewMatrix; 
float4x4 ProjectionMatrix; 
float	 vTime;

float4x4 AbsoluteWorldMatrix;

sampler BaseTexture  =
sampler_state
{
##	Texture = <tex0>;
	MinFilter = Linear;
	MagFilter = Linear;
	WrapS = Repeat;
	WrapT = Repeat;
};

sampler AlphaTexture  =
sampler_state
{
##	Texture = <tex1>;
	MinFilter = Linear;
	MagFilter = Linear;
	WrapS = ClampToEdge;
	WrapT = ClampToEdge;
};

sampler SandTexture  =
sampler_state
{
##	Texture = <tex2>;
	MinFilter = Linear;
	MagFilter = Linear;
	WrapS = ClampToEdge;
	WrapT = ClampToEdge;
};


sampler TerraIncognitaFiltered  =
sampler_state
{
##	Texture = <tex3>;
	MinFilter = Linear;
	MagFilter = Linear;
	WrapS = ClampToEdge;
	WrapT = ClampToEdge;
};

struct VS_INPUT
{
    float4 vPosition  : POSITION;
    float2 vTexCoord0 : TEXCOORD0;
};

struct VS_OUTPUT
{
    float4  vPosition  : POSITION;
    float2  vTexCoord0 : TEXCOORD0;
    float2  vTexCoord1 : TEXCOORD1;
    float2  vTexCoord2 : TEXCOORD2;
    float2  vTexCoord3 : TEXCOORD3;
};


VS_OUTPUT VertexShader_Beach(const VS_INPUT v )
{
	VS_OUTPUT Out = (VS_OUTPUT)0;
	float4x4 WorldView = mul(WorldMatrix, ViewMatrix);
	float3 P = mul(v.vPosition, (float4x3)WorldView);
	Out.vPosition  = mul(float4(P, 1), ProjectionMatrix);

	Out.vTexCoord1 = v.vTexCoord0;
	Out.vTexCoord0 = v.vTexCoord0 - float2( 0, vTime* 0.3 );
	Out.vTexCoord3 = v.vTexCoord0;

	float4 WorldPosition = mul( v.vPosition, AbsoluteWorldMatrix );
	Out.vTexCoord2 = float2( WorldPosition.x/2048.0f, WorldPosition.z/1024.0f );

	return Out;
}

float4 PixelShader_Beach( VS_OUTPUT v ) : COLOR
{
	float4 OutColor = tex2D( BaseTexture, v.vTexCoord0.xy );
	float4 AlphaColor = tex2D( AlphaTexture, v.vTexCoord1.xy );
	OutColor.rgba *= AlphaColor.a;

	float4 TerraIncognita = tex2D( TerraIncognitaFiltered, v.vTexCoord2 );

	OutColor.rgb += ( TerraIncognita.g +(-0.25) )*1.33;
	if ( TerraIncognita.g > 0.7 )
		OutColor.a = 0;
	return OutColor;
}

technique BeachShader
{
	pass p0
	{
		BlendEnable = true;
		AlphaTestEnable = true;

		VertexProgram = compile arbvp1 VertexShader_Beach();
		FragmentProgram = compile arbfp1 PixelShader_Beach();
	}
}
